"""
Copyright (c) 2023, Zscaler Inc.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
"""

from typing import Dict, List, Optional, Any, Union
from zscaler.oneapi_object import ZscalerObject


class AppConnectorSchedule(ZscalerObject):
    def __init__(self, config: Optional[Dict[str, Any]] = None) -> None:
        """
        Initialize the AppConnectorSchedule model based on API response.

        Args:
            config (dict): A dictionary representing the App Connector Schedule configuration.
        """
        super().__init__(config)
        if config:
            self.id = config["id"] if "id" in config else None
            self.frequency_interval = config["frequencyInterval"] if "frequencyInterval" in config else None
            self.frequency = config["frequency"] if "frequency" in config else None
            self.enabled = config["enabled"] if "enabled" in config else None
            self.customer_id = config["customerId"] if "customerId" in config else None
            self.delete_disabled = config["deleteDisabled"] if "deleteDisabled" in config else None
        else:
            self.id = None
            self.frequency_interval = None
            self.frequency = None
            self.enabled = None
            self.customer_id = None
            self.delete_disabled = None

    def request_format(self) -> Dict[str, Any]:
        parent_req_format = super().request_format()
        current_obj_format = {
            "id": self.id,
            "frequencyInterval": self.frequency_interval,
            "frequency": self.frequency,
            "enabled": self.enabled,
            "customerId": self.customer_id,
            "deleteDisabled": self.delete_disabled,
        }
        parent_req_format.update(current_obj_format)
        return parent_req_format
