# pylint: disable=line-too-long
"""Constants for the Notification CC."""

# ----------------------------------------------------------------------------------- #
# **BEGINNING OF AUTOGENERATED CONTENT** (TO ADD ADDITIONAL MANUAL CONTENT, LOOK FOR  #
# THE "END OF AUTOGENERATED CONTENT" COMMENT BLOCK AND ADD YOUR CODE BELOW IT)        #
# ----------------------------------------------------------------------------------- #

from __future__ import annotations

from enum import IntEnum

CC_SPECIFIC_NOTIFICATION_TYPE = "notificationType"


class NotificationType(IntEnum):
    """Enum for known notification types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    ACCESS_CONTROL = 6
    APPLIANCE = 12
    CLOCK = 11
    CO_ALARM = 2
    CO2_ALARM = 3
    EMERGENCY_ALARM = 10
    GAS_ALARM = 18
    HEAT_ALARM = 4
    HOME_HEALTH = 13
    HOME_MONITORING = 22
    HOME_SECURITY = 7
    IRRIGATION = 17
    LIGHT_SENSOR = 20
    PEST_CONTROL = 19
    POWER_MANAGEMENT = 8
    SIREN = 14
    SMOKE_ALARM = 1
    SYSTEM = 9
    WATER_ALARM = 5
    WATER_QUALITY_MONITORING = 21
    WATER_VALVE = 15
    WEATHER_ALARM = 16


class NotificationEvent(IntEnum):
    """Common base class for Notification CC states enums."""


class NotificationEventValue(IntEnum):
    """Common base class for Notification CC state value enums."""


class AccessControlNotificationEvent(NotificationEvent):
    """Enum for known access control notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALL_USER_CODES_DELETED = 12
    AUTO_LOCK_LOCKED_OPERATION = 9
    AUTO_LOCK_NOT_FULLY_LOCKED_OPERATION = 10
    BARRIER_BATTERY_STATUS_BARRIER_SENSOR_LOW_BATTERY_WARNING = 74
    BARRIER_CONTROL_STATUS_BARRIER_ASSOCIATED_WITH_NON_Z_WAVE_REMOTE_CONTROL = 76
    BARRIER_FAILED_TO_PERFORM_REQUESTED_OPERATION_DEVICE_MALFUNCTION = 70
    BARRIER_MOTOR_HAS_EXCEEDED_MANUFACTURER_S_OPERATIONAL_TIME_LIMIT = 66
    BARRIER_OPERATION_OPEN_CLOSE_FORCE_HAS_BEEN_EXCEEDED = 65
    BARRIER_OPERATION_HAS_EXCEEDED_PHYSICAL_MECHANICAL_LIMITS = 67
    BARRIER_PERFORMING_INITIALIZATION_PROCESS = 64
    BARRIER_SAFETY_BEAM_OBSTACLE = 72
    BARRIER_SENSOR_STATUS_BARRIER_SENSOR_NOT_DETECTED_SUPERVISORY_ERROR = 73
    BARRIER_SHORT_CIRCUIT_STATUS_BARRIER_DETECTED_SHORT_IN_WALL_STATION_WIRES = 75
    BARRIER_UL_DISABLING_STATUS_BARRIER_UNATTENDED_OPERATION_HAS_BEEN_DISABLED_PER_UL_REQUIREMENTS = (
        69
    )
    BARRIER_UNABLE_TO_PERFORM_REQUESTED_OPERATION_DUE_TO_UL_REQUIREMENTS = 68
    BARRIER_VACATION_MODE = 71
    DOOR_HANDLE_STATE_WINDOW_DOOR_HANDLE_IS_CLOSED = 25
    DOOR_HANDLE_STATE_WINDOW_DOOR_HANDLE_IS_OPEN = 24
    DOOR_STATE_WINDOW_DOOR_IS_CLOSED = 23
    DOOR_STATE_WINDOW_DOOR_IS_OPEN = 22
    KEYPAD_LOCK_OPERATION = 5
    KEYPAD_STATE_KEYPAD_BUSY = 17
    KEYPAD_STATE_KEYPAD_TEMPORARY_DISABLED = 16
    KEYPAD_UNLOCK_OPERATION = 6
    LOCK_OPERATION_WITH_USER_CODE = 33
    LOCK_STATE_LOCK_JAMMED = 11
    LOCKED_BY_RF_WITH_INVALID_USER_CODE = 21
    MANUAL_LOCK_OPERATION = 1
    MANUAL_NOT_FULLY_LOCKED_OPERATION = 7
    MANUAL_UNLOCK_OPERATION = 2
    MANUALLY_ENTER_USER_ACCESS_CODE_EXCEEDS_CODE_LIMIT = 19
    MESSAGING_USER_CODE_ENTERED_VIA_KEYPAD = 32
    NEW_PROGRAM_CODE_ENTERED_UNIQUE_CODE_FOR_LOCK_CONFIGURATION = 18
    NEW_USER_CODE_ADDED = 14
    NEW_USER_CODE_NOT_ADDED_DUE_TO_DUPLICATE_CODE = 15
    RF_LOCK_OPERATION = 3
    RF_NOT_FULLY_LOCKED_OPERATION = 8
    RF_UNLOCK_OPERATION = 4
    SINGLE_USER_CODE_DELETED = 13
    UNLOCK_BY_RF_WITH_INVALID_USER_CODE = 20
    UNLOCK_OPERATION_WITH_USER_CODE = 34

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> AccessControlNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return AccessControlNotificationEvent.UNKNOWN


class BarrierPerformingInitializationProcessNotificationEventValue(
    NotificationEventValue
):
    """Enum for known barrier performing initialization process notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    PERFORMING_PROCESS = 255
    PROCESS_COMPLETED = 0

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> BarrierPerformingInitializationProcessNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return BarrierPerformingInitializationProcessNotificationEventValue.UNKNOWN


class BarrierSafetyBeamObstacleNotificationEventValue(NotificationEventValue):
    """Enum for known barrier safety beam obstacle notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    NO_OBSTRUCTION = 0
    OBSTRUCTION = 255

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> BarrierSafetyBeamObstacleNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return BarrierSafetyBeamObstacleNotificationEventValue.UNKNOWN


class BarrierVacationModeNotificationEventValue(NotificationEventValue):
    """Enum for known barrier vacation mode notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    MODE_DISABLED = 0
    MODE_ENABLED = 255

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> BarrierVacationModeNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return BarrierVacationModeNotificationEventValue.UNKNOWN


class DoorStateWindowDoorIsOpenNotificationEventValue(NotificationEventValue):
    """Enum for known door state window/door is open notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    WINDOW_DOOR_IS_OPEN_IN_REGULAR_POSITION = 0
    WINDOW_DOOR_IS_OPEN_IN_TILT_POSITION = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> DoorStateWindowDoorIsOpenNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return DoorStateWindowDoorIsOpenNotificationEventValue.UNKNOWN


class ApplianceNotificationEvent(NotificationEvent):
    """Enum for known appliance notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    APPLIANCE_STATUS_BOILING = 8
    APPLIANCE_STATUS_DRAINING = 14
    APPLIANCE_STATUS_DRYING = 18
    APPLIANCE_STATUS_RINSING = 12
    APPLIANCE_STATUS_SPINNING = 16
    APPLIANCE_STATUS_SUPPLYING_WATER = 6
    APPLIANCE_STATUS_WASHING = 10
    BOILING_FAILURE = 9
    COMPRESSOR_FAILURE = 21
    DRAINING_FAILURE = 15
    DRYING_FAILURE = 19
    FAN_FAILURE = 20
    MAINTENANCE_STATUS_REPLACE_MAIN_FILTER = 4
    PROGRAM_STATUS_PROGRAM_COMPLETED = 3
    PROGRAM_STATUS_PROGRAM_IN_PROGRESS = 2
    PROGRAM_STATUS_PROGRAM_STARTED = 1
    RINSING_FAILURE = 13
    SPINNING_FAILURE = 17
    TARGET_TEMPERATURE_FAILURE_STATUS_FAILURE_TO_SET_TARGET_TEMPERATURE = 5
    WASHING_FAILURE = 11
    WATER_SUPPLY_FAILURE = 7

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> ApplianceNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return ApplianceNotificationEvent.UNKNOWN


class ClockNotificationEvent(NotificationEvent):
    """Enum for known clock notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    TIME_REMAINING = 3
    TIMER_ENDED = 2
    WAKE_UP_ALERT = 1

    @classmethod
    def _missing_(cls: type, value: object) -> ClockNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return ClockNotificationEvent.UNKNOWN


class CoAlarmNotificationEvent(NotificationEvent):
    """Enum for known co alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALARM_STATUS_ALARM_SILENCED = 6
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED = 4
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED_END_OF_LIFE = 5
    PERIODIC_INSPECTION_STATUS_MAINTENANCE_REQUIRED_PLANNED_PERIODIC_INSPECTION = 7
    SENSOR_STATUS_CARBON_MONOXIDE_DETECTED = 2
    SENSOR_STATUS_CARBON_MONOXIDE_DETECTED_LOCATION_PROVIDED = 1
    TEST_STATUS_CARBON_MONOXIDE_TEST = 3

    @classmethod
    def _missing_(cls: type, value: object) -> CoAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return CoAlarmNotificationEvent.UNKNOWN


class TestStatusCarbonMonoxideTestNotificationEventValue(NotificationEventValue):
    """Enum for known test status carbon monoxide test notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    TEST_FAILED = 2
    TEST_OK = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> TestStatusCarbonMonoxideTestNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return TestStatusCarbonMonoxideTestNotificationEventValue.UNKNOWN


class Co2AlarmNotificationEvent(NotificationEvent):
    """Enum for known co2 alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALARM_STATUS_ALARM_SILENCED = 6
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED = 4
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED_END_OF_LIFE = 5
    PERIODIC_INSPECTION_STATUS_MAINTENANCE_REQUIRED_PLANNED_PERIODIC_INSPECTION = 7
    SENSOR_STATUS_CARBON_DIOXIDE_DETECTED = 2
    SENSOR_STATUS_CARBON_DIOXIDE_DETECTED_LOCATION_PROVIDED = 1
    TEST_STATUS_CARBON_DIOXIDE_TEST = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> Co2AlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return Co2AlarmNotificationEvent.UNKNOWN


class TestStatusCarbonDioxideTestNotificationEventValue(NotificationEventValue):
    """Enum for known test status carbon dioxide test notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    TEST_FAILED = 2
    TEST_OK = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> TestStatusCarbonDioxideTestNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return TestStatusCarbonDioxideTestNotificationEventValue.UNKNOWN


class EmergencyAlarmNotificationEvent(NotificationEvent):
    """Enum for known emergency alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    CONTACT_FIRE_SERVICE = 2
    CONTACT_MEDICAL_SERVICE = 3
    CONTACT_POLICE = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> EmergencyAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return EmergencyAlarmNotificationEvent.UNKNOWN


class GasAlarmNotificationEvent(NotificationEvent):
    """Enum for known gas alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALARM_STATUS_GAS_ALARM_TEST = 5
    COMBUSTIBLE_GAS_STATUS_COMBUSTIBLE_GAS_DETECTED = 2
    COMBUSTIBLE_GAS_STATUS_COMBUSTIBLE_GAS_DETECTED_LOCATION_PROVIDED = 1
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED = 6
    TOXIC_GAS_STATUS_TOXIC_GAS_DETECTED = 4
    TOXIC_GAS_STATUS_TOXIC_GAS_DETECTED_LOCATION_PROVIDED = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> GasAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return GasAlarmNotificationEvent.UNKNOWN


class HeatAlarmNotificationEvent(NotificationEvent):
    """Enum for known heat alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALARM_STATUS_ALARM_SILENCED = 9
    ALARM_STATUS_HEAT_ALARM_TEST = 7
    DUST_IN_DEVICE_STATUS_MAINTENANCE_REQUIRED_DUST_IN_DEVICE = 10
    HEAT_SENSOR_STATUS_OVERHEAT_DETECTED = 2
    HEAT_SENSOR_STATUS_OVERHEAT_DETECTED_LOCATION_PROVIDED = 1
    HEAT_SENSOR_STATUS_UNDERHEAT_DETECTED = 6
    HEAT_SENSOR_STATUS_UNDERHEAT_DETECTED_LOCATION_PROVIDED = 5
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED_END_OF_LIFE = 8
    PERIODIC_INSPECTION_STATUS_MAINTENANCE_REQUIRED_PLANNED_PERIODIC_INSPECTION = 11
    RAPID_TEMPERATURE_FALL = 13
    RAPID_TEMPERATURE_FALL_LOCATION_PROVIDED = 12
    RAPID_TEMPERATURE_RISE = 4
    RAPID_TEMPERATURE_RISE_LOCATION_PROVIDED = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> HeatAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return HeatAlarmNotificationEvent.UNKNOWN


class HomeHealthNotificationEvent(NotificationEvent):
    """Enum for known home health notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    FALL_DETECTED = 12
    POSITION_STATUS_LEAVING_BED = 1
    POSITION_STATUS_LYING_ON_BED = 3
    POSITION_STATUS_SITTING_ON_BED = 2
    POSITION_STATUS_SITTING_ON_BED_EDGE = 5
    POSTURE_CHANGED = 4
    SLEEP_APNEA_STATUS_SLEEP_APNEA_DETECTED = 7
    SLEEP_STAGE_STATUS_SLEEP_STAGE_0_DETECTED_DREAMING_REM = 8
    SLEEP_STAGE_STATUS_SLEEP_STAGE_1_DETECTED_LIGHT_SLEEP_NON_REM_1 = 9
    SLEEP_STAGE_STATUS_SLEEP_STAGE_2_DETECTED_MEDIUM_SLEEP_NON_REM_2 = 10
    SLEEP_STAGE_STATUS_SLEEP_STAGE_3_DETECTED_DEEP_SLEEP_NON_REM_3 = 11
    VOC_LEVEL_STATUS_VOLATILE_ORGANIC_COMPOUND_LEVEL = 6

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> HomeHealthNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return HomeHealthNotificationEvent.UNKNOWN


class SleepApneaStatusSleepApneaDetectedNotificationEventValue(NotificationEventValue):
    """Enum for known sleep apnea status sleep apnea detected notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    LOW_BREATH = 1
    NO_BREATH_AT_ALL = 2

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> SleepApneaStatusSleepApneaDetectedNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return SleepApneaStatusSleepApneaDetectedNotificationEventValue.UNKNOWN


class VocLevelStatusVolatileOrganicCompoundLevelNotificationEventValue(
    NotificationEventValue
):
    """Enum for known voc level status volatile organic compound level notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    CLEAN = 1
    HIGHLY_POLLUTED = 4
    MODERATELY_POLLUTED = 3
    SLIGHTLY_POLLUTED = 2

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> (
        VocLevelStatusVolatileOrganicCompoundLevelNotificationEventValue
    ):  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return VocLevelStatusVolatileOrganicCompoundLevelNotificationEventValue.UNKNOWN


class HomeMonitoringNotificationEvent(NotificationEvent):
    """Enum for known home monitoring notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    HOME_OCCUPANCY_STATUS_HOME_OCCUPIED = 2
    HOME_OCCUPANCY_STATUS_HOME_OCCUPIED_LOCATION_PROVIDED = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> HomeMonitoringNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return HomeMonitoringNotificationEvent.UNKNOWN


class HomeSecurityNotificationEvent(NotificationEvent):
    """Enum for known home security notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    COVER_STATUS_TAMPERING_PRODUCT_COVER_REMOVED = 3
    GLASS_BREAKAGE = 6
    GLASS_BREAKAGE_LOCATION_PROVIDED = 5
    IMPACT_DETECTED = 10
    MAGNETIC_INTERFERENCE_STATUS_MAGNETIC_FIELD_INTERFERENCE_DETECTED = 11
    MOTION_SENSOR_STATUS_MOTION_DETECTION = 8
    MOTION_SENSOR_STATUS_MOTION_DETECTION_LOCATION_PROVIDED = 7
    RF_JAMMING_DETECTED = 12
    SENSOR_STATUS_INTRUSION = 2
    SENSOR_STATUS_INTRUSION_LOCATION_PROVIDED = 1
    TAMPERING_INVALID_CODE = 4
    TAMPERING_PRODUCT_MOVED = 9

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> HomeSecurityNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return HomeSecurityNotificationEvent.UNKNOWN


class IrrigationNotificationEvent(NotificationEvent):
    """Enum for known irrigation notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    DEVICE_CONFIGURATION_STATUS_DEVICE_IS_NOT_CONFIGURED = 5
    SCHEDULE_ID_STATUS_SCHEDULE_FINISHED = 2
    SCHEDULE_ID_STATUS_SCHEDULE_STARTED = 1
    VALVE_ID_RUN_STATUS_VALVE_TABLE_RUN_FINISHED = 4
    VALVE_ID_RUN_STATUS_VALVE_TABLE_RUN_STARTED = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> IrrigationNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return IrrigationNotificationEvent.UNKNOWN


class LightSensorNotificationEvent(NotificationEvent):
    """Enum for known light sensor notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    LIGHT_COLOR_TRANSITION_DETECTED = 2
    LIGHT_DETECTION_STATUS_LIGHT_DETECTED = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> LightSensorNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return LightSensorNotificationEvent.UNKNOWN


class PestControlNotificationEvent(NotificationEvent):
    """Enum for known pest control notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    PEST_DETECTED = 6
    PEST_DETECTED_LOCATION_PROVIDED = 5
    PEST_EXTERMINATED = 8
    PEST_EXTERMINATED_LOCATION_PROVIDED = 7
    TRAP_STATUS_TRAP_ARMED = 2
    TRAP_STATUS_TRAP_ARMED_LOCATION_PROVIDED = 1
    TRAP_STATUS_TRAP_RE_ARM_REQUIRED = 4
    TRAP_STATUS_TRAP_RE_ARM_REQUIRED_LOCATION_PROVIDED = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> PestControlNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return PestControlNotificationEvent.UNKNOWN


class PowerManagementNotificationEvent(NotificationEvent):
    """Enum for known power management notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    BACKUP_BATTERY_LEVEL_STATUS_BACK_UP_BATTERY_DISCONNECTED = 18
    BACKUP_BATTERY_LEVEL_STATUS_BACK_UP_BATTERY_IS_LOW = 16
    BATTERY_LEVEL_STATUS_BATTERY_IS_FULLY_CHARGED = 13
    BATTERY_LEVEL_STATUS_CHARGE_BATTERY_NOW = 15
    BATTERY_LEVEL_STATUS_CHARGE_BATTERY_SOON = 14
    BATTERY_LOAD_STATUS_BATTERY_IS_CHARGING = 12
    BATTERY_MAINTENANCE_STATUS_BATTERY_FLUID_IS_LOW = 17
    BATTERY_MAINTENANCE_STATUS_REPLACE_BATTERY_NOW = 11
    BATTERY_MAINTENANCE_STATUS_REPLACE_BATTERY_SOON = 10
    LOAD_ERROR = 9
    MAINS_STATUS_AC_MAINS_DISCONNECTED = 2
    MAINS_STATUS_AC_MAINS_RE_CONNECTED = 3
    OVER_CURRENT_STATUS_OVER_CURRENT_DETECTED = 6
    OVER_LOAD_STATUS_OVER_LOAD_DETECTED = 8
    OVER_VOLTAGE_STATUS_OVER_VOLTAGE_DETECTED = 7
    POWER_STATUS_POWER_HAS_BEEN_APPLIED = 1
    SURGE_DETECTED = 4
    VOLTAGE_DROP_DRIFT = 5

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> PowerManagementNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return PowerManagementNotificationEvent.UNKNOWN


class SirenNotificationEvent(NotificationEvent):
    """Enum for known siren notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    SIREN_STATUS_SIREN_ACTIVE = 1

    @classmethod
    def _missing_(cls: type, value: object) -> SirenNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return SirenNotificationEvent.UNKNOWN


class SmokeAlarmNotificationEvent(NotificationEvent):
    """Enum for known smoke alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ALARM_STATUS_ALARM_SILENCED = 6
    ALARM_STATUS_SMOKE_ALARM_TEST = 3
    DUST_IN_DEVICE_STATUS_MAINTENANCE_REQUIRED_DUST_IN_DEVICE = 8
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED = 4
    MAINTENANCE_STATUS_REPLACEMENT_REQUIRED_END_OF_LIFE = 5
    PERIODIC_INSPECTION_STATUS_MAINTENANCE_REQUIRED_PLANNED_PERIODIC_INSPECTION = 7
    SENSOR_STATUS_SMOKE_DETECTED = 2
    SENSOR_STATUS_SMOKE_DETECTED_LOCATION_PROVIDED = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> SmokeAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return SmokeAlarmNotificationEvent.UNKNOWN


class SystemNotificationEvent(NotificationEvent):
    """Enum for known system notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    COVER_STATUS_TAMPERING_PRODUCT_COVER_REMOVED = 6
    EMERGENCY_SHUTOFF = 7
    HARDWARE_STATUS_SYSTEM_HARDWARE_FAILURE = 1
    HARDWARE_STATUS_SYSTEM_HARDWARE_FAILURE_WITH_FAILURE_CODE = 3
    HEARTBEAT = 5
    SOFTWARE_STATUS_SYSTEM_SOFTWARE_FAILURE = 2
    SOFTWARE_STATUS_SYSTEM_SOFTWARE_FAILURE_WITH_FAILURE_CODE = 4

    @classmethod
    def _missing_(cls: type, value: object) -> SystemNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return SystemNotificationEvent.UNKNOWN


class WaterAlarmNotificationEvent(NotificationEvent):
    """Enum for known water alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    MAINTENANCE_STATUS_REPLACE_WATER_FILTER = 5
    PUMP_STATUS_SUMP_PUMP_ACTIVE = 10
    PUMP_STATUS_SUMP_PUMP_FAILURE = 11
    SENSOR_STATUS_WATER_LEAK_DETECTED = 2
    SENSOR_STATUS_WATER_LEAK_DETECTED_LOCATION_PROVIDED = 1
    WATER_FLOW_ALARM = 6
    WATER_LEVEL_ALARM = 9
    WATER_LEVEL_DROPPED = 4
    WATER_LEVEL_DROPPED_LOCATION_PROVIDED = 3
    WATER_PRESSURE_ALARM = 7
    WATER_TEMPERATURE_ALARM = 8

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterAlarmNotificationEvent.UNKNOWN


class WaterFlowAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known water flow alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    MAX = 4
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterFlowAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterFlowAlarmNotificationEventValue.UNKNOWN


class WaterLevelAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known water level alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterLevelAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterLevelAlarmNotificationEventValue.UNKNOWN


class WaterPressureAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known water pressure alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    MAX = 4
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterPressureAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterPressureAlarmNotificationEventValue.UNKNOWN


class WaterTemperatureAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known water temperature alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterTemperatureAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterTemperatureAlarmNotificationEventValue.UNKNOWN


class WaterQualityMonitoringNotificationEvent(NotificationEvent):
    """Enum for known water quality monitoring notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ACIDITY_PH_SENSOR_STATUS_ACIDITY_PH_EMPTY = 5
    ACIDITY_PH_STATUS_ACIDITY_PH_ALARM = 2
    CHLORINE_ALARM = 1
    CHLORINE_SENSOR_STATUS_CHLORINE_EMPTY = 4
    COLLECTIVE_DISORDER = 17
    DISINFECTION_SYSTEM_STATUS_DISINFECTION_SYSTEM_ERROR_DETECTED = 8
    DRY_PROTECTION_STATUS_DRY_PROTECTION_OPERATION_ACTIVE = 13
    FILTER_CLEANING_STATUS_FILTER_CLEANING_ONGOING = 9
    FILTER_PUMP_STATUS_FILTER_PUMP_OPERATION_ONGOING = 11
    FRESHWATER_FLOW_STATUS_FRESHWATER_OPERATION_ONGOING = 12
    HEATING_STATUS_HEATING_OPERATION_ONGOING = 10
    WATER_OXIDATION_ALARM = 3
    WATER_TANK_STATUS_WATER_TANK_IS_EMPTY = 14
    WATER_TANK_STATUS_WATER_TANK_IS_FULL = 16
    WATER_TANK_STATUS_WATER_TANK_LEVEL_IS_UNKNOWN = 15
    WATERFLOW_CLEAR_WATER_SENSOR_WATERFLOW_CLEAR_WATER_SHORTAGE_DETECTED = 7
    WATERFLOW_MEASURING_STATION_SENSOR_WATERFLOW_MEASURING_STATION_SHORTAGE_DETECTED = 6

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterQualityMonitoringNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterQualityMonitoringNotificationEvent.UNKNOWN


class AcidityStatusAcidityAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known acidity (ph) status acidity (ph) alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 2
    BELOW_LOW_THRESHOLD = 1
    DECREASING_PH = 3
    INCREASING_PH = 4

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> AcidityStatusAcidityAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return AcidityStatusAcidityAlarmNotificationEventValue.UNKNOWN


class ChlorineAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known chlorine alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 2
    BELOW_LOW_THRESHOLD = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> ChlorineAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return ChlorineAlarmNotificationEventValue.UNKNOWN


class WaterOxidationAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known water oxidation alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 2
    BELOW_LOW_THRESHOLD = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterOxidationAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterOxidationAlarmNotificationEventValue.UNKNOWN


class WaterValveNotificationEvent(NotificationEvent):
    """Enum for known water valve notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    MASTER_VALVE_CURRENT_ALARM = 6
    MASTER_VALVE_OPERATION = 2
    MASTER_VALVE_SHORT_CIRCUIT = 4
    VALVE_CURRENT_ALARM = 5
    VALVE_OPERATION = 1
    VALVE_SHORT_CIRCUIT = 3

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WaterValveNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WaterValveNotificationEvent.UNKNOWN


class MasterValveCurrentAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known master valve current alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    MAX = 4
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> MasterValveCurrentAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return MasterValveCurrentAlarmNotificationEventValue.UNKNOWN


class MasterValveOperationNotificationEventValue(NotificationEventValue):
    """Enum for known master valve operation notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    OFF_CLOSED = 0
    ON_OPEN = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> MasterValveOperationNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return MasterValveOperationNotificationEventValue.UNKNOWN


class ValveCurrentAlarmNotificationEventValue(NotificationEventValue):
    """Enum for known valve current alarm notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    ABOVE_HIGH_THRESHOLD = 3
    BELOW_LOW_THRESHOLD = 2
    MAX = 4
    NO_DATA = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> ValveCurrentAlarmNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return ValveCurrentAlarmNotificationEventValue.UNKNOWN


class ValveOperationNotificationEventValue(NotificationEventValue):
    """Enum for known valve operation notification event value."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    OFF_CLOSED = 0
    ON_OPEN = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> ValveOperationNotificationEventValue:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return ValveOperationNotificationEventValue.UNKNOWN


class WeatherAlarmNotificationEvent(NotificationEvent):
    """Enum for known weather alarm notification event."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/notifications.json
    UNKNOWN = -1
    FREEZE_ALARM = 3
    MOISTURE_ALARM = 2
    RAIN_ALARM = 1

    @classmethod
    def _missing_(
        cls: type, value: object
    ) -> WeatherAlarmNotificationEvent:  # noqa: ARG003
        """Set default enum member if an unknown value is provided."""
        return WeatherAlarmNotificationEvent.UNKNOWN


NOTIFICATION_TYPE_TO_EVENT_MAP: dict[NotificationType, type[NotificationEvent]] = {
    NotificationType.ACCESS_CONTROL: AccessControlNotificationEvent,
    NotificationType.APPLIANCE: ApplianceNotificationEvent,
    NotificationType.CLOCK: ClockNotificationEvent,
    NotificationType.CO_ALARM: CoAlarmNotificationEvent,
    NotificationType.CO2_ALARM: Co2AlarmNotificationEvent,
    NotificationType.EMERGENCY_ALARM: EmergencyAlarmNotificationEvent,
    NotificationType.GAS_ALARM: GasAlarmNotificationEvent,
    NotificationType.HEAT_ALARM: HeatAlarmNotificationEvent,
    NotificationType.HOME_HEALTH: HomeHealthNotificationEvent,
    NotificationType.HOME_MONITORING: HomeMonitoringNotificationEvent,
    NotificationType.HOME_SECURITY: HomeSecurityNotificationEvent,
    NotificationType.IRRIGATION: IrrigationNotificationEvent,
    NotificationType.LIGHT_SENSOR: LightSensorNotificationEvent,
    NotificationType.PEST_CONTROL: PestControlNotificationEvent,
    NotificationType.POWER_MANAGEMENT: PowerManagementNotificationEvent,
    NotificationType.SIREN: SirenNotificationEvent,
    NotificationType.SMOKE_ALARM: SmokeAlarmNotificationEvent,
    NotificationType.SYSTEM: SystemNotificationEvent,
    NotificationType.WATER_ALARM: WaterAlarmNotificationEvent,
    NotificationType.WATER_QUALITY_MONITORING: WaterQualityMonitoringNotificationEvent,
    NotificationType.WATER_VALVE: WaterValveNotificationEvent,
    NotificationType.WEATHER_ALARM: WeatherAlarmNotificationEvent,
}

NOTIFICATION_EVENT_TO_EVENT_VALUE_MAP: dict[
    NotificationEvent, type[NotificationEventValue]
] = {
    AccessControlNotificationEvent.BARRIER_PERFORMING_INITIALIZATION_PROCESS: BarrierPerformingInitializationProcessNotificationEventValue,
    AccessControlNotificationEvent.BARRIER_SAFETY_BEAM_OBSTACLE: BarrierSafetyBeamObstacleNotificationEventValue,
    AccessControlNotificationEvent.BARRIER_VACATION_MODE: BarrierVacationModeNotificationEventValue,
    AccessControlNotificationEvent.DOOR_STATE_WINDOW_DOOR_IS_OPEN: DoorStateWindowDoorIsOpenNotificationEventValue,
    Co2AlarmNotificationEvent.TEST_STATUS_CARBON_DIOXIDE_TEST: TestStatusCarbonDioxideTestNotificationEventValue,
    CoAlarmNotificationEvent.TEST_STATUS_CARBON_MONOXIDE_TEST: TestStatusCarbonMonoxideTestNotificationEventValue,
    HomeHealthNotificationEvent.SLEEP_APNEA_STATUS_SLEEP_APNEA_DETECTED: SleepApneaStatusSleepApneaDetectedNotificationEventValue,
    HomeHealthNotificationEvent.VOC_LEVEL_STATUS_VOLATILE_ORGANIC_COMPOUND_LEVEL: VocLevelStatusVolatileOrganicCompoundLevelNotificationEventValue,
    WaterAlarmNotificationEvent.WATER_FLOW_ALARM: WaterFlowAlarmNotificationEventValue,
    WaterAlarmNotificationEvent.WATER_LEVEL_ALARM: WaterLevelAlarmNotificationEventValue,
    WaterAlarmNotificationEvent.WATER_PRESSURE_ALARM: WaterPressureAlarmNotificationEventValue,
    WaterAlarmNotificationEvent.WATER_TEMPERATURE_ALARM: WaterTemperatureAlarmNotificationEventValue,
    WaterQualityMonitoringNotificationEvent.ACIDITY_PH_STATUS_ACIDITY_PH_ALARM: AcidityStatusAcidityAlarmNotificationEventValue,
    WaterQualityMonitoringNotificationEvent.CHLORINE_ALARM: ChlorineAlarmNotificationEventValue,
    WaterQualityMonitoringNotificationEvent.WATER_OXIDATION_ALARM: WaterOxidationAlarmNotificationEventValue,
    WaterValveNotificationEvent.MASTER_VALVE_CURRENT_ALARM: MasterValveCurrentAlarmNotificationEventValue,
    WaterValveNotificationEvent.MASTER_VALVE_OPERATION: MasterValveOperationNotificationEventValue,
    WaterValveNotificationEvent.VALVE_CURRENT_ALARM: ValveCurrentAlarmNotificationEventValue,
    WaterValveNotificationEvent.VALVE_OPERATION: ValveOperationNotificationEventValue,
}


# ----------------------------------------------------------------------------------- #
# **END OF AUTOGENERATED CONTENT** (DO NOT EDIT/REMOVE THIS COMMENT BLOCK AND DO NOT  #
# EDIT ANYTHING ABOVE IT. IF A NEW IMPORT IS NEEDED, UPDATE THE LINES AROUND 135      #
# IN scripts/generate_multilevel_sensor_constants.py THEN RE-RUN THE SCRIPT. ALL      #
# LINES WRITTEN BELOW THIS BLOCK WILL BE PRESERVED AS LONG AS THIS BLOCK REMAINS)     #
# ----------------------------------------------------------------------------------- #
